package gov.va.med.mhv.sm.web.reports;

import gov.va.med.mhv.sm.enumeration.CountsSubCategoryEnum;
import gov.va.med.mhv.sm.enumeration.ReportingCountsTypeEnum;
import gov.va.med.mhv.sm.web.actions.BaseSMAdminAction;

import com.opensymphony.xwork2.Preparable;

public class CountsTrendsSwitch extends BaseSMAdminAction implements Preparable {
	private static final long serialVersionUID = 1L;
	
	public static String SWITCH = "SWITCH";
	
	@Override
	public void prepare() throws Exception {
		super.prepare();
	}
	
	public String switchToCounts() {
		setSessionAttribute(SWITCH,ReportingCountsTypeEnum.COUNTS);
		
		//Since the sub-categories change depending which view we can't preserve it between views.
		//So reset it if there is no matching filter.
		Integer cur = (Integer)getSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
		if( cur != null) {
			if( cur==-1 || !CountsSubCategoryEnum.valueOf(cur).isCounts()) {
				removeSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
			}
		}
		return SUCCESS;
	}

	public String switchToTrends() {
		setSessionAttribute(SWITCH,ReportingCountsTypeEnum.TRENDS);
		
		//Since the sub-categories change depending which view we can't preserve it between views.
		//So reset it if there is no matching filter.
		Integer cur = (Integer)getSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
		if( cur != null) {
			if(  cur==-1 || !CountsSubCategoryEnum.valueOf(cur).isTrends()) {
				removeSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
			}
		}
		return SUCCESS;
	}

	public String switchToDashboard() {
		setSessionAttribute(SWITCH,ReportingCountsTypeEnum.DASHBOARD);
		
		//Since the sub-categories change depending which view we can't preserve it between views.
		//So reset it if there is no matching filter.
		Integer cur = (Integer)getSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
		if( cur != null) {
			if(  cur==-1 || !CountsSubCategoryEnum.valueOf(cur).isDashboard()) {
				removeSessionAttribute(CountsTrendsSubCategoryFilter.SUB_CATEGORY_FILTER);
			}
		}
		return SUCCESS;
	}
}
